#include "SkinDefs.r"

resource 'Skin' (1) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Basique HD",				/* Skin name - can be 23 chars + zero at the end */
	HIGHDENSITY,						/* High resolution mode */
	4,							/* Minimal supported color depth */
	

	16,						/* Title height */
	YES,						/* Standard Palm OS title with time */
	0,							/* Title bar bitmap ID */
	{0, 0, 0, 0},			/* Title bar rectangle */

	8002,						/* Refresh button bitmap ID */
	8010,						/* Refresh button selected bitmap ID */
	{40, 2, 10, 10},		/* Refresh button rectangle */

	8003,						/* Memory bitmap ID */
	{53, 1, 31, 12},		/* Memory - the full size rectangle */
	{54, 3, 27, 7},		/* Memory - bar display rectangle */
	220,						/* Memory - delimiting vertical line color color */
	6,							/* Memory - delimiting vertical line color gray */

	8004,						/* Battery bitmap ID */
	8025,						/* Battery charging bitmap ID */
	{85, 1, 31, 12},		/* Battery - the full size rectangle */
	{86, 2, 25, 8},		/* Battery - bar display rectangle */
	64,						/* Battery - delimiting vertical line color color */
	10,						/* Battery - delimiting vertical line color gray */
	
	8014,						/* Homer bitmap ID */
	8021,						/* Homer selected bitmap ID */
	{0, 150, 10, 10},		/* Homer bitmap rectangle */
	{0, 150, 10, 10},		/* Homer hot-spot rectangle */

	8013,						/* Gadget toggle bitmap ID */
	8020,						/* Gadget toggle selected bitmap ID */
	{150, 150, 10, 10},	/* Gadget toggle bitmap rectangle */
	{150, 150, 10, 10},	/* Gadget toggle hot-spot rectangle */

	8012,						/* Gadget bar background bitmap ID */
	{0, 141, 160, 19},	/* Gadget bar background rectangle */

	8,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{14, 143},				/* starting point for drawing gadgets */
	3,							/* gadget horizontal padding */
	14,						/* gadget width */
	16,						/* gadget height */
	
	13,						/* Number of gadgets */
	8100,						/* First gadget bitmap ID */
	8200,						/* First gadget selected bitmap ID */
	
	8151,						/* GadgetLockUnlock bitmapID */
	8152,						/* GadgetLockUnlock selected bitmapID */
	
	{3, 16, 150, 137},	/* App area - gadgets hidden*/
	{1, 16, 152, 125},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	7,							/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	89,						/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	3,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4400,						/* First category icon bitmap ID */
	11,						/* Category icon width */
	10,						/* Category icon height */

	NONE,						/* Tabs position */
	NO,						/* Two rows of tabs */
	0,							/* Bitmap ID of the slice: left */
	0,							/* Bitmap ID of the slice: selected left */
	0,							/* Bitmap ID of the slice: selected right */
	0,							/* Bitmap ID of the slice: right */	
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	0,							/* Slice height */
	0,							/* Left slice width */
	0,							/* Upper line thickness */
	0,							/* Non-selected real height */
	
	0,							/* Bitmap ID of the "Previous tab" scroll arrow */
	0,							/* Bitmap ID of the "Next tab" scroll arrow */
	0,							/* Tab scroll arrow height */
	0,							/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{0, 15, 160, 145}		/* App area to be painted with the background color */
	};

resource 'Skin' (2) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Top HD",		/* Skin name - can be 23 chars + zero at the end */
	HIGHDENSITY,						/* High resolution mode */
	4,							/* Minimal supported color depth */
	

	14,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	8001,						/* Title bar bitmap ID */
	{0, 0, 78, 12},		/* Title bar rectangle */

	8002,						/* Refresh button bitmap ID */
	8010,						/* Refresh button selected bitmap ID */
	{81, 1, 10, 10},		/* Refresh button rectangle */

	8003,						/* Memory bitmap ID */
	{96, 0, 31, 12},		/* Memory - the full size rectangle */
	{97, 2, 27, 7},		/* Memory - bar display rectangle */
	220,						/* Memory - delimiting vertical line color color */
	6,							/* Memory - delimiting vertical line color gray */

	8004,						/* Battery bitmap ID */
	8025,						/* Battery charging bitmap ID */
	{128, 0, 31, 12},		/* Battery - the full size rectangle */
	{129, 1, 25, 8},		/* Battery - bar display rectangle */
	64,						/* Battery - delimiting vertical line color color */
	10,						/* Battery - delimiting vertical line color gray */
	
	8014,						/* Homer bitmap ID */
	8021,						/* Homer selected bitmap ID */
	{0, 150, 10, 10},		/* Homer bitmap rectangle */
	{0, 150, 10, 10},		/* Homer hot-spot rectangle */

	8013,						/* Gadget toggle bitmap ID */
	8020,						/* Gadget toggle selected bitmap ID */
	{150, 150, 10, 10},	/* Gadget toggle bitmap rectangle */
	{150, 150, 10, 10},	/* Gadget toggle hot-spot rectangle */

	8012,						/* Gadget bar background bitmap ID */
	{0, 141, 160, 19},	/* Gadget bar background rectangle */

	8,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{14, 143},				/* starting point for drawing gadgets */
	3,							/* gadget horizontal padding */
	14,						/* gadget width */
	16,						/* gadget height */
	
	13,						/* Number of gadgets */
	8100,						/* First gadget bitmap ID */
	8200,						/* First gadget selected bitmap ID */
	
	8151,						/* GadgetLockUnlock bitmapID */
	8152,						/* GadgetLockUnlock selected bitmapID */
	
	{3, 30, 150, 124},	/* App area - gadgets hidden*/
	{3, 30, 150, 111},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	7,							/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	89,						/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	3,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4400,						/* First category icon bitmap ID */
	11,						/* Category icon width */
	10,						/* Category icon height */
/***********/
	UP,						/* Tabs position */
	NO,						/* Two rows of tabs */
	4200,						/* Bitmap ID of the slice: left */
	4201,						/* Bitmap ID of the slice: selected left */
	4202,						/* Bitmap ID of the slice: selected right */
	4203,						/* Bitmap ID of the slice: right */	
	4214,						/* Bitmap ID of the slice: left after selected */
	4214,						/* Bitmap ID of the slice: right - non-last tab */
	16,						/* Slice height */
	6,							/* Left slice width */
	1,							/* Upper line thickness */
	14,						/* Non-selected real height */
	
	4204,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4205,						/* Bitmap ID of the "Next tab" scroll arrow */
	10,						/* Tab scroll arrow height */
	7,							/* Tab scroll arrow width */

	4,							/* horizontal offset from the left side of the left slice */
	1,							/* horizontal offset from the left side of the "afer selected" slice */
	2,							/* horizontal offset from the right side of the right slice */
	1,							/* horizontal offset from the right side of the "before selected" slice */
	2,							/* vertical offset from the top of the slice */
	3,							/* vertical offset from the top of the selected slice */

	{0, 29, 160, 131}		/* App area to be painted with the background color */
	};

resource 'Skin' (3) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Left HD",	/* Skin name - can be 23 chars + zero at the end */
	HIGHDENSITY,						/* High resolution mode */
	4,							/* Minimal supported color depth */
	

	14,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	8001,						/* Title bar bitmap ID */
	{0, 0, 78, 12},		/* Title bar rectangle */

	8002,						/* Refresh button bitmap ID */
	8010,						/* Refresh button selected bitmap ID */
	{81, 1, 10, 10},		/* Refresh button rectangle */

	8003,						/* Memory bitmap ID */
	{96, 0, 31, 12},		/* Memory - the full size rectangle */
	{97, 2, 27, 7},		/* Memory - bar display rectangle */
	220,						/* Memory - delimiting vertical line color color */
	6,							/* Memory - delimiting vertical line color gray */

	8004,						/* Battery bitmap ID */
	8025,						/* Battery charging bitmap ID */
	{128, 0, 31, 12},		/* Battery - the full size rectangle */
	{129, 1, 25, 8},		/* Battery - bar display rectangle */
	64,						/* Battery - delimiting vertical line color color */
	10,						/* Battery - delimiting vertical line color gray */
	
	8014,						/* Homer bitmap ID */
	8021,						/* Homer selected bitmap ID */
	{0, 150, 10, 10},		/* Homer bitmap rectangle */
	{0, 150, 10, 10},		/* Homer hot-spot rectangle */

	8013,						/* Gadget toggle bitmap ID */
	8020,						/* Gadget toggle selected bitmap ID */
	{150, 150, 10, 10},	/* Gadget toggle bitmap rectangle */
	{150, 150, 10, 10},	/* Gadget toggle hot-spot rectangle */

	8012,						/* Gadget bar background bitmap ID */
	{0, 141, 160, 19},	/* Gadget bar background rectangle */

	8,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{14, 143},				/* starting point for drawing gadgets */
	3,							/* gadget horizontal padding */
	14,						/* gadget width */
	16,						/* gadget height */
	
	13,						/* Number of gadgets */
	8100,						/* First gadget bitmap ID */
	8200,						/* First gadget selected bitmap ID */
	
	8151,						/* GadgetLockUnlock bitmapID */
	8152,						/* GadgetLockUnlock selected bitmapID */
	
	{41, 16, 112, 137},	/* App area - gadgets hidden*/
	{41, 16, 112, 125},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	7,							/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	89,						/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	3,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4400,						/* First category icon bitmap ID */
	11,						/* Category icon width */
	10,						/* Category icon height */
/***********/
	LEFT,						/* Tabs position */
	NO,						/* Two rows of tabs */
	4206,						/* Bitmap ID of the slice: left */ /* unselected */
	4207,						/* Bitmap ID of the slice: selected left */ /* selected */
	4208,						/* Bitmap ID of the slice: selected right */ /* unselected last */
	9,							/* Bitmap ID of the slice: right */ /* max number of tabs */
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	13,						/* Slice height */ /* unselected height */
	40,						/* Left slice width */ /* total width */
	37,						/*  Upper line thickness */ /* unselected width */
	15,						/* Non-selected real height *//* last & selected height */
	
	4209,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4210,						/* Bitmap ID of the "Next tab" scroll arrow */
	7,							/* Tab scroll arrow height */
	10,						/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{40, 15, 120, 145}	/* App area to be painted with the background color */
	};


resource 'Skin' (4) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Right HD",	/* Skin name - can be 23 chars + zero at the end */
	HIGHDENSITY,						/* High resolution mode */
	4,							/* Minimal supported color depth */
	

	14,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	8001,						/* Title bar bitmap ID */
	{0, 0, 78, 12},		/* Title bar rectangle */

	8002,						/* Refresh button bitmap ID */
	8010,						/* Refresh button selected bitmap ID */
	{81, 1, 10, 10},		/* Refresh button rectangle */

	8003,						/* Memory bitmap ID */
	{96, 0, 31, 12},		/* Memory - the full size rectangle */
	{97, 2, 27, 7},		/* Memory - bar display rectangle */
	220,						/* Memory - delimiting vertical line color color */
	6,							/* Memory - delimiting vertical line color gray */

	8004,						/* Battery bitmap ID */
	8025,						/* Battery charging bitmap ID */
	{128, 0, 31, 12},		/* Battery - the full size rectangle */
	{129, 1, 25, 8},		/* Battery - bar display rectangle */
	64,						/* Battery - delimiting vertical line color color */
	10,						/* Battery - delimiting vertical line color gray */
	
	8014,						/* Homer bitmap ID */
	8021,						/* Homer selected bitmap ID */
	{0, 150, 10, 10},		/* Homer bitmap rectangle */
	{0, 150, 10, 10},		/* Homer hot-spot rectangle */

	8013,						/* Gadget toggle bitmap ID */
	8020,						/* Gadget toggle selected bitmap ID */
	{150, 150, 10, 10},	/* Gadget toggle bitmap rectangle */
	{150, 150, 10, 10},	/* Gadget toggle hot-spot rectangle */

	8012,						/* Gadget bar background bitmap ID */
	{0, 141, 160, 19},	/* Gadget bar background rectangle */

	8,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{14, 143},				/* starting point for drawing gadgets */
	3,							/* gadget horizontal padding */
	14,						/* gadget width */
	16,						/* gadget height */
	
	13,						/* Number of gadgets */
	8100,						/* First gadget bitmap ID */
	8200,						/* First gadget selected bitmap ID */
	
	8151,						/* GadgetLockUnlock bitmapID */
	8152,						/* GadgetLockUnlock selected bitmapID */
	
	{0, 16, 112, 135},	/* App area - gadgets hidden*/
	{0, 16, 112, 125},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	7,							/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	89,						/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	3,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4400,						/* First category icon bitmap ID */
	11,						/* Category icon width */
	10,						/* Category icon height */
/***********/
	RIGHT,					/* Tabs position */
	NO,						/* Two rows of tabs */
	4211,						/* Bitmap ID of the slice: left */ /* unselected */
	4212,						/* Bitmap ID of the slice: selected left */ /* selected */
	4213,						/* Bitmap ID of the slice: selected right */ /* unselected last */
	9,							/* Bitmap ID of the slice: right */ /* max number of tabs */
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	13,						/* Slice height */ /* unselected height */
	40,						/* Left slice width */ /* total width */
	37,						/* Right slice width */ /* unselected width */
	15,						/* Non-selected real height *//* last & selected height */
	
	4209,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4210,						/* Bitmap ID of the "Next tab" scroll arrow */
	7,							/* Tab scroll arrow height */
	10,						/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{0, 15, 120, 145}			/* App area to be painted with the background color */
	};

